-----------------------------------------------------------------------------
Tranches de Transporteurs par Pays :

SELECT trans.nom AS transporteur, trch.nom AS tranche
FROM shop_transporteurs_tranches AS trch
INNER JOIN shop_zones_couverture AS co ON co.id_zone = trch.id_zone
INNER JOIN shop_transporteurs AS trans ON trans.id = trch.id_transporteur
WHERE trans.id_boutique = $id_boutique AND co.id_pays = $id_pays AND co.id_region = 0

-----------------------------------------------------------------------------
Tranches de Transporteurs par Pays et Rgion :

SELECT trans.nom AS transporteur, trch.nom AS tranche
FROM shop_transporteurs_tranches AS trch
INNER JOIN shop_zones_couverture AS co ON co.id_zone = trch.id_zone
INNER JOIN shop_transporteurs AS trans ON trans.id = trch.id_transporteur
WHERE trans.id_boutique = $id_boutique AND co.id_pays = $id_pays AND (co.id_region = $id_region OR co.id_region = 0)

-----------------------------------------------------------------------------
Pays par Boutique :

SELECT pays.*
FROM shop_zones_pays AS pays
INNER JOIN shop_zones_couverture AS couv ON couv.id_pays = pays.id
INNER JOIN shop_transporteurs_tranches AS trch ON trch.id_zone = couv.id_zone
INNER JOIN shop_transporteurs AS trans ON trans.id = trch.id_transporteur
WHERE trans.id_boutique = $id_boutique

-----------------------------------------------------------------------------
Rgions par Pays et Boutique :

SELECT reg.*
FROM shop_zones_regions AS reg
INNER JOIN shop_zones_couverture AS couv ON couv.id_pays = reg.id_pays AND couv.id_region = reg.id
INNER JOIN shop_transporteurs_tranches AS trch ON trch.id_zone = couv.id_zone
INNER JOIN shop_transporteurs AS trans ON trans.id = trch.id_transporteur
WHERE trans.id_boutique = $id_boutique